package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCPSEnrollmentsEnrollmentCsr private(
  city: String,
  countryCode: String,
  organization: String,
  organizationalUnit: String,
  preferredTrustChain: String,
  state: String
) derives Decoder

object GetCPSEnrollmentsEnrollmentCsr:
  given outputOps: {} with
    extension(output: Output[GetCPSEnrollmentsEnrollmentCsr])
      def city: Output[String] = output.map(_.city)
      def countryCode: Output[String] = output.map(_.countryCode)
      def organization: Output[String] = output.map(_.organization)
      def organizationalUnit: Output[String] = output.map(_.organizationalUnit)
      def preferredTrustChain: Output[String] = output.map(_.preferredTrustChain)
      def state: Output[String] = output.map(_.state)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCPSEnrollmentsEnrollmentCsr]])
      def city: Output[Option[String]] = output.map(_.map(_.city))
      def countryCode: Output[Option[String]] = output.map(_.map(_.countryCode))
      def organization: Output[Option[String]] = output.map(_.map(_.organization))
      def organizationalUnit: Output[Option[String]] = output.map(_.map(_.organizationalUnit))
      def preferredTrustChain: Output[Option[String]] = output.map(_.map(_.preferredTrustChain))
      def state: Output[Option[String]] = output.map(_.map(_.state))


