package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetClientlistListsList private(
  createDate: String,
  createdBy: String,
  deprecated: Boolean,
  itemsCount: Int,
  listId: String,
  listType: String,
  name: Option[String],
  notes: String,
  productionActivationStatus: String,
  readOnly: Boolean,
  shared: Boolean,
  stagingActivationStatus: String,
  tags: scala.collection.immutable.List[String],
  `type`: Option[String],
  updateDate: String,
  updatedBy: String,
  version: Int
) derives Decoder

object GetClientlistListsList:
  given outputOps: {} with
    extension(output: Output[GetClientlistListsList])
      def createDate: Output[String] = output.map(_.createDate)
      def createdBy: Output[String] = output.map(_.createdBy)
      def deprecated: Output[Boolean] = output.map(_.deprecated)
      def itemsCount: Output[Int] = output.map(_.itemsCount)
      def listId: Output[String] = output.map(_.listId)
      def listType: Output[String] = output.map(_.listType)
      def name: Output[Option[String]] = output.map(_.name)
      def notes: Output[String] = output.map(_.notes)
      def productionActivationStatus: Output[String] = output.map(_.productionActivationStatus)
      def readOnly: Output[Boolean] = output.map(_.readOnly)
      def shared: Output[Boolean] = output.map(_.shared)
      def stagingActivationStatus: Output[String] = output.map(_.stagingActivationStatus)
      def tags: Output[scala.collection.immutable.List[String]] = output.map(_.tags)
      def `type`: Output[Option[String]] = output.map(_.`type`)
      def updateDate: Output[String] = output.map(_.updateDate)
      def updatedBy: Output[String] = output.map(_.updatedBy)
      def version: Output[Int] = output.map(_.version)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetClientlistListsList]])
      def createDate: Output[Option[String]] = output.map(_.map(_.createDate))
      def createdBy: Output[Option[String]] = output.map(_.map(_.createdBy))
      def deprecated: Output[Option[Boolean]] = output.map(_.map(_.deprecated))
      def itemsCount: Output[Option[Int]] = output.map(_.map(_.itemsCount))
      def listId: Output[Option[String]] = output.map(_.map(_.listId))
      def listType: Output[Option[String]] = output.map(_.map(_.listType))
      def name: Output[Option[String]] = output.map(_.flatMap(_.name))
      def notes: Output[Option[String]] = output.map(_.map(_.notes))
      def productionActivationStatus: Output[Option[String]] = output.map(_.map(_.productionActivationStatus))
      def readOnly: Output[Option[Boolean]] = output.map(_.map(_.readOnly))
      def shared: Output[Option[Boolean]] = output.map(_.map(_.shared))
      def stagingActivationStatus: Output[Option[String]] = output.map(_.map(_.stagingActivationStatus))
      def tags: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.map(_.tags))
      def `type`: Output[Option[String]] = output.map(_.flatMap(_.`type`))
      def updateDate: Output[Option[String]] = output.map(_.map(_.updateDate))
      def updatedBy: Output[Option[String]] = output.map(_.map(_.updatedBy))
      def version: Output[Option[Int]] = output.map(_.map(_.version))


