package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudletsApplicationLoadBalancerDataCenter private(
  city: String,
  cloudServerHostHeaderOverride: Boolean,
  cloudService: Boolean,
  continent: String,
  country: String,
  hostname: String,
  latitude: Double,
  livenessHosts: scala.collection.immutable.List[String],
  longitude: Double,
  originId: String,
  percent: Double,
  stateOrProvince: String
) derives Decoder

object GetCloudletsApplicationLoadBalancerDataCenter:
  given outputOps: {} with
    extension(output: Output[GetCloudletsApplicationLoadBalancerDataCenter])
      def city: Output[String] = output.map(_.city)
      def cloudServerHostHeaderOverride: Output[Boolean] = output.map(_.cloudServerHostHeaderOverride)
      def cloudService: Output[Boolean] = output.map(_.cloudService)
      def continent: Output[String] = output.map(_.continent)
      def country: Output[String] = output.map(_.country)
      def hostname: Output[String] = output.map(_.hostname)
      def latitude: Output[Double] = output.map(_.latitude)
      def livenessHosts: Output[scala.collection.immutable.List[String]] = output.map(_.livenessHosts)
      def longitude: Output[Double] = output.map(_.longitude)
      def originId: Output[String] = output.map(_.originId)
      def percent: Output[Double] = output.map(_.percent)
      def stateOrProvince: Output[String] = output.map(_.stateOrProvince)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudletsApplicationLoadBalancerDataCenter]])
      def city: Output[Option[String]] = output.map(_.map(_.city))
      def cloudServerHostHeaderOverride: Output[Option[Boolean]] = output.map(_.map(_.cloudServerHostHeaderOverride))
      def cloudService: Output[Option[Boolean]] = output.map(_.map(_.cloudService))
      def continent: Output[Option[String]] = output.map(_.map(_.continent))
      def country: Output[Option[String]] = output.map(_.map(_.country))
      def hostname: Output[Option[String]] = output.map(_.map(_.hostname))
      def latitude: Output[Option[Double]] = output.map(_.map(_.latitude))
      def livenessHosts: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.map(_.livenessHosts))
      def longitude: Output[Option[Double]] = output.map(_.map(_.longitude))
      def originId: Output[Option[String]] = output.map(_.map(_.originId))
      def percent: Output[Option[Double]] = output.map(_.map(_.percent))
      def stateOrProvince: Output[Option[String]] = output.map(_.map(_.stateOrProvince))


