package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudletsApplicationLoadBalancerLivenessSetting private(
  additionalHeaders: scala.Predef.Map[String, String],
  hostHeader: String,
  interval: Int,
  path: String,
  peerCertificateVerification: Boolean,
  port: Int,
  protocol: String,
  requestString: String,
  responseString: String,
  status3xxFailure: Boolean,
  status4xxFailure: Boolean,
  status5xxFailure: Boolean,
  timeout: Double
) derives Decoder

object GetCloudletsApplicationLoadBalancerLivenessSetting:
  given outputOps: {} with
    extension(output: Output[GetCloudletsApplicationLoadBalancerLivenessSetting])
      def additionalHeaders: Output[scala.Predef.Map[String, String]] = output.map(_.additionalHeaders)
      def hostHeader: Output[String] = output.map(_.hostHeader)
      def interval: Output[Int] = output.map(_.interval)
      def path: Output[String] = output.map(_.path)
      def peerCertificateVerification: Output[Boolean] = output.map(_.peerCertificateVerification)
      def port: Output[Int] = output.map(_.port)
      def protocol: Output[String] = output.map(_.protocol)
      def requestString: Output[String] = output.map(_.requestString)
      def responseString: Output[String] = output.map(_.responseString)
      def status3xxFailure: Output[Boolean] = output.map(_.status3xxFailure)
      def status4xxFailure: Output[Boolean] = output.map(_.status4xxFailure)
      def status5xxFailure: Output[Boolean] = output.map(_.status5xxFailure)
      def timeout: Output[Double] = output.map(_.timeout)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudletsApplicationLoadBalancerLivenessSetting]])
      def additionalHeaders: Output[Option[scala.Predef.Map[String, String]]] = output.map(_.map(_.additionalHeaders))
      def hostHeader: Output[Option[String]] = output.map(_.map(_.hostHeader))
      def interval: Output[Option[Int]] = output.map(_.map(_.interval))
      def path: Output[Option[String]] = output.map(_.map(_.path))
      def peerCertificateVerification: Output[Option[Boolean]] = output.map(_.map(_.peerCertificateVerification))
      def port: Output[Option[Int]] = output.map(_.map(_.port))
      def protocol: Output[Option[String]] = output.map(_.map(_.protocol))
      def requestString: Output[Option[String]] = output.map(_.map(_.requestString))
      def responseString: Output[Option[String]] = output.map(_.map(_.responseString))
      def status3xxFailure: Output[Option[Boolean]] = output.map(_.map(_.status3xxFailure))
      def status4xxFailure: Output[Option[Boolean]] = output.map(_.map(_.status4xxFailure))
      def status5xxFailure: Output[Option[Boolean]] = output.map(_.map(_.status5xxFailure))
      def timeout: Output[Option[Double]] = output.map(_.map(_.timeout))


