package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudletsEdgeRedirectorMatchRuleMatchRule private(
  disabled: Option[Boolean],
  end: Option[Int],
  matchUrl: Option[String],
  matches: Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudletsEdgeRedirectorMatchRuleMatchRuleMatch]],
  name: Option[String],
  redirectUrl: String,
  start: Option[Int],
  statusCode: Int,
  `type`: String,
  useIncomingQueryString: Option[Boolean],
  useRelativeUrl: Option[String]
) derives Decoder

object GetCloudletsEdgeRedirectorMatchRuleMatchRule:
  given outputOps: {} with
    extension(output: Output[GetCloudletsEdgeRedirectorMatchRuleMatchRule])
      def disabled: Output[Option[Boolean]] = output.map(_.disabled)
      def end: Output[Option[Int]] = output.map(_.end)
      def matchUrl: Output[Option[String]] = output.map(_.matchUrl)
      def matches: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudletsEdgeRedirectorMatchRuleMatchRuleMatch]]] = output.map(_.matches)
      def name: Output[Option[String]] = output.map(_.name)
      def redirectUrl: Output[String] = output.map(_.redirectUrl)
      def start: Output[Option[Int]] = output.map(_.start)
      def statusCode: Output[Int] = output.map(_.statusCode)
      def `type`: Output[String] = output.map(_.`type`)
      def useIncomingQueryString: Output[Option[Boolean]] = output.map(_.useIncomingQueryString)
      def useRelativeUrl: Output[Option[String]] = output.map(_.useRelativeUrl)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudletsEdgeRedirectorMatchRuleMatchRule]])
      def disabled: Output[Option[Boolean]] = output.map(_.flatMap(_.disabled))
      def end: Output[Option[Int]] = output.map(_.flatMap(_.end))
      def matchUrl: Output[Option[String]] = output.map(_.flatMap(_.matchUrl))
      def matches: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudletsEdgeRedirectorMatchRuleMatchRuleMatch]]] = output.map(_.flatMap(_.matches))
      def name: Output[Option[String]] = output.map(_.flatMap(_.name))
      def redirectUrl: Output[Option[String]] = output.map(_.map(_.redirectUrl))
      def start: Output[Option[Int]] = output.map(_.flatMap(_.start))
      def statusCode: Output[Option[Int]] = output.map(_.map(_.statusCode))
      def `type`: Output[Option[String]] = output.map(_.map(_.`type`))
      def useIncomingQueryString: Output[Option[Boolean]] = output.map(_.flatMap(_.useIncomingQueryString))
      def useRelativeUrl: Output[Option[String]] = output.map(_.flatMap(_.useRelativeUrl))


