package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudletsPolicyActivation private(
  apiVersion: String,
  network: String,
  policyInfos: scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudletsPolicyActivationPolicyInfo],
  propertyInfos: scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudletsPolicyActivationPropertyInfo]
) derives Decoder

object GetCloudletsPolicyActivation:
  given outputOps: {} with
    extension(output: Output[GetCloudletsPolicyActivation])
      def apiVersion: Output[String] = output.map(_.apiVersion)
      def network: Output[String] = output.map(_.network)
      def policyInfos: Output[scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudletsPolicyActivationPolicyInfo]] = output.map(_.policyInfos)
      def propertyInfos: Output[scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudletsPolicyActivationPropertyInfo]] = output.map(_.propertyInfos)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudletsPolicyActivation]])
      def apiVersion: Output[Option[String]] = output.map(_.map(_.apiVersion))
      def network: Output[Option[String]] = output.map(_.map(_.network))
      def policyInfos: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudletsPolicyActivationPolicyInfo]]] = output.map(_.map(_.policyInfos))
      def propertyInfos: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudletsPolicyActivationPropertyInfo]]] = output.map(_.map(_.propertyInfos))


