package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudletsPolicyActivationPolicyInfo private(
  activatedBy: String,
  activationDate: Int,
  name: String,
  policyId: Int,
  status: String,
  statusDetail: String,
  version: Int
) derives Decoder

object GetCloudletsPolicyActivationPolicyInfo:
  given outputOps: {} with
    extension(output: Output[GetCloudletsPolicyActivationPolicyInfo])
      def activatedBy: Output[String] = output.map(_.activatedBy)
      def activationDate: Output[Int] = output.map(_.activationDate)
      def name: Output[String] = output.map(_.name)
      def policyId: Output[Int] = output.map(_.policyId)
      def status: Output[String] = output.map(_.status)
      def statusDetail: Output[String] = output.map(_.statusDetail)
      def version: Output[Int] = output.map(_.version)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudletsPolicyActivationPolicyInfo]])
      def activatedBy: Output[Option[String]] = output.map(_.map(_.activatedBy))
      def activationDate: Output[Option[Int]] = output.map(_.map(_.activationDate))
      def name: Output[Option[String]] = output.map(_.map(_.name))
      def policyId: Output[Option[Int]] = output.map(_.map(_.policyId))
      def status: Output[Option[String]] = output.map(_.map(_.status))
      def statusDetail: Output[Option[String]] = output.map(_.map(_.statusDetail))
      def version: Output[Option[Int]] = output.map(_.map(_.version))


