package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudletsPolicyActivationPropertyInfo private(
  activatedBy: String,
  activationDate: Int,
  groupId: Int,
  name: String,
  status: String,
  version: Int
) derives Decoder

object GetCloudletsPolicyActivationPropertyInfo:
  given outputOps: {} with
    extension(output: Output[GetCloudletsPolicyActivationPropertyInfo])
      def activatedBy: Output[String] = output.map(_.activatedBy)
      def activationDate: Output[Int] = output.map(_.activationDate)
      def groupId: Output[Int] = output.map(_.groupId)
      def name: Output[String] = output.map(_.name)
      def status: Output[String] = output.map(_.status)
      def version: Output[Int] = output.map(_.version)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudletsPolicyActivationPropertyInfo]])
      def activatedBy: Output[Option[String]] = output.map(_.map(_.activatedBy))
      def activationDate: Output[Option[Int]] = output.map(_.map(_.activationDate))
      def groupId: Output[Option[Int]] = output.map(_.map(_.groupId))
      def name: Output[Option[String]] = output.map(_.map(_.name))
      def status: Output[Option[String]] = output.map(_.map(_.status))
      def version: Output[Option[Int]] = output.map(_.map(_.version))


