package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudwrapperCapacitiesCapacity private(
  approved: besom.api.akamai.outputs.GetCloudwrapperCapacitiesCapacityApproved,
  assigned: besom.api.akamai.outputs.GetCloudwrapperCapacitiesCapacityAssigned,
  contractId: String,
  locationId: Int,
  locationName: String,
  `type`: String,
  unassigned: besom.api.akamai.outputs.GetCloudwrapperCapacitiesCapacityUnassigned
) derives Decoder

object GetCloudwrapperCapacitiesCapacity:
  given outputOps: {} with
    extension(output: Output[GetCloudwrapperCapacitiesCapacity])
      def approved: Output[besom.api.akamai.outputs.GetCloudwrapperCapacitiesCapacityApproved] = output.map(_.approved)
      def assigned: Output[besom.api.akamai.outputs.GetCloudwrapperCapacitiesCapacityAssigned] = output.map(_.assigned)
      def contractId: Output[String] = output.map(_.contractId)
      def locationId: Output[Int] = output.map(_.locationId)
      def locationName: Output[String] = output.map(_.locationName)
      def `type`: Output[String] = output.map(_.`type`)
      def unassigned: Output[besom.api.akamai.outputs.GetCloudwrapperCapacitiesCapacityUnassigned] = output.map(_.unassigned)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudwrapperCapacitiesCapacity]])
      def approved: Output[Option[besom.api.akamai.outputs.GetCloudwrapperCapacitiesCapacityApproved]] = output.map(_.map(_.approved))
      def assigned: Output[Option[besom.api.akamai.outputs.GetCloudwrapperCapacitiesCapacityAssigned]] = output.map(_.map(_.assigned))
      def contractId: Output[Option[String]] = output.map(_.map(_.contractId))
      def locationId: Output[Option[Int]] = output.map(_.map(_.locationId))
      def locationName: Output[Option[String]] = output.map(_.map(_.locationName))
      def `type`: Output[Option[String]] = output.map(_.map(_.`type`))
      def unassigned: Output[Option[besom.api.akamai.outputs.GetCloudwrapperCapacitiesCapacityUnassigned]] = output.map(_.map(_.unassigned))


