package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudwrapperConfigurationLocation private(
  capacity: besom.api.akamai.outputs.GetCloudwrapperConfigurationLocationCapacity,
  comments: String,
  mapName: String,
  trafficTypeId: Int
) derives Decoder

object GetCloudwrapperConfigurationLocation:
  given outputOps: {} with
    extension(output: Output[GetCloudwrapperConfigurationLocation])
      def capacity: Output[besom.api.akamai.outputs.GetCloudwrapperConfigurationLocationCapacity] = output.map(_.capacity)
      def comments: Output[String] = output.map(_.comments)
      def mapName: Output[String] = output.map(_.mapName)
      def trafficTypeId: Output[Int] = output.map(_.trafficTypeId)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudwrapperConfigurationLocation]])
      def capacity: Output[Option[besom.api.akamai.outputs.GetCloudwrapperConfigurationLocationCapacity]] = output.map(_.map(_.capacity))
      def comments: Output[Option[String]] = output.map(_.map(_.comments))
      def mapName: Output[Option[String]] = output.map(_.map(_.mapName))
      def trafficTypeId: Output[Option[Int]] = output.map(_.map(_.trafficTypeId))


