package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudwrapperConfigurationMultiCdnSettingsBocc private(
  conditionalSamplingFrequency: String,
  enabled: Boolean,
  forwardType: String,
  requestType: String,
  samplingFrequency: String
) derives Decoder

object GetCloudwrapperConfigurationMultiCdnSettingsBocc:
  given outputOps: {} with
    extension(output: Output[GetCloudwrapperConfigurationMultiCdnSettingsBocc])
      def conditionalSamplingFrequency: Output[String] = output.map(_.conditionalSamplingFrequency)
      def enabled: Output[Boolean] = output.map(_.enabled)
      def forwardType: Output[String] = output.map(_.forwardType)
      def requestType: Output[String] = output.map(_.requestType)
      def samplingFrequency: Output[String] = output.map(_.samplingFrequency)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudwrapperConfigurationMultiCdnSettingsBocc]])
      def conditionalSamplingFrequency: Output[Option[String]] = output.map(_.map(_.conditionalSamplingFrequency))
      def enabled: Output[Option[Boolean]] = output.map(_.map(_.enabled))
      def forwardType: Output[Option[String]] = output.map(_.map(_.forwardType))
      def requestType: Output[Option[String]] = output.map(_.map(_.requestType))
      def samplingFrequency: Output[Option[String]] = output.map(_.map(_.samplingFrequency))


