package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudwrapperConfigurationMultiCdnSettingsCdnCdnAuthKey private(
  authKeyName: String,
  expiryDate: String,
  headerName: String,
  secret: String
) derives Decoder

object GetCloudwrapperConfigurationMultiCdnSettingsCdnCdnAuthKey:
  given outputOps: {} with
    extension(output: Output[GetCloudwrapperConfigurationMultiCdnSettingsCdnCdnAuthKey])
      def authKeyName: Output[String] = output.map(_.authKeyName)
      def expiryDate: Output[String] = output.map(_.expiryDate)
      def headerName: Output[String] = output.map(_.headerName)
      def secret: Output[String] = output.map(_.secret)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudwrapperConfigurationMultiCdnSettingsCdnCdnAuthKey]])
      def authKeyName: Output[Option[String]] = output.map(_.map(_.authKeyName))
      def expiryDate: Output[Option[String]] = output.map(_.map(_.expiryDate))
      def headerName: Output[Option[String]] = output.map(_.map(_.headerName))
      def secret: Output[Option[String]] = output.map(_.map(_.secret))


