package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudwrapperConfigurationsConfiguration private(
  capacityAlertsThreshold: Int,
  comments: String,
  configName: String,
  contractId: String,
  id: Int,
  lastActivatedBy: String,
  lastActivatedDate: String,
  lastUpdatedBy: String,
  lastUpdatedDate: String,
  locations: Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudwrapperConfigurationsConfigurationLocation]],
  multiCdnSettings: Option[besom.api.akamai.outputs.GetCloudwrapperConfigurationsConfigurationMultiCdnSettings],
  notificationEmails: scala.collection.immutable.List[String],
  propertyIds: scala.collection.immutable.List[String],
  retainIdleObjects: Boolean,
  status: String
) derives Decoder

object GetCloudwrapperConfigurationsConfiguration:
  given outputOps: {} with
    extension(output: Output[GetCloudwrapperConfigurationsConfiguration])
      def capacityAlertsThreshold: Output[Int] = output.map(_.capacityAlertsThreshold)
      def comments: Output[String] = output.map(_.comments)
      def configName: Output[String] = output.map(_.configName)
      def contractId: Output[String] = output.map(_.contractId)
      def id: Output[Int] = output.map(_.id)
      def lastActivatedBy: Output[String] = output.map(_.lastActivatedBy)
      def lastActivatedDate: Output[String] = output.map(_.lastActivatedDate)
      def lastUpdatedBy: Output[String] = output.map(_.lastUpdatedBy)
      def lastUpdatedDate: Output[String] = output.map(_.lastUpdatedDate)
      def locations: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudwrapperConfigurationsConfigurationLocation]]] = output.map(_.locations)
      def multiCdnSettings: Output[Option[besom.api.akamai.outputs.GetCloudwrapperConfigurationsConfigurationMultiCdnSettings]] = output.map(_.multiCdnSettings)
      def notificationEmails: Output[scala.collection.immutable.List[String]] = output.map(_.notificationEmails)
      def propertyIds: Output[scala.collection.immutable.List[String]] = output.map(_.propertyIds)
      def retainIdleObjects: Output[Boolean] = output.map(_.retainIdleObjects)
      def status: Output[String] = output.map(_.status)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudwrapperConfigurationsConfiguration]])
      def capacityAlertsThreshold: Output[Option[Int]] = output.map(_.map(_.capacityAlertsThreshold))
      def comments: Output[Option[String]] = output.map(_.map(_.comments))
      def configName: Output[Option[String]] = output.map(_.map(_.configName))
      def contractId: Output[Option[String]] = output.map(_.map(_.contractId))
      def id: Output[Option[Int]] = output.map(_.map(_.id))
      def lastActivatedBy: Output[Option[String]] = output.map(_.map(_.lastActivatedBy))
      def lastActivatedDate: Output[Option[String]] = output.map(_.map(_.lastActivatedDate))
      def lastUpdatedBy: Output[Option[String]] = output.map(_.map(_.lastUpdatedBy))
      def lastUpdatedDate: Output[Option[String]] = output.map(_.map(_.lastUpdatedDate))
      def locations: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudwrapperConfigurationsConfigurationLocation]]] = output.map(_.flatMap(_.locations))
      def multiCdnSettings: Output[Option[besom.api.akamai.outputs.GetCloudwrapperConfigurationsConfigurationMultiCdnSettings]] = output.map(_.flatMap(_.multiCdnSettings))
      def notificationEmails: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.map(_.notificationEmails))
      def propertyIds: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.map(_.propertyIds))
      def retainIdleObjects: Output[Option[Boolean]] = output.map(_.map(_.retainIdleObjects))
      def status: Output[Option[String]] = output.map(_.map(_.status))


