package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudwrapperLocationsLocation private(
  locationId: Int,
  locationName: String,
  multiCdnLocationId: String,
  trafficTypes: Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudwrapperLocationsLocationTrafficType]]
) derives Decoder

object GetCloudwrapperLocationsLocation:
  given outputOps: {} with
    extension(output: Output[GetCloudwrapperLocationsLocation])
      def locationId: Output[Int] = output.map(_.locationId)
      def locationName: Output[String] = output.map(_.locationName)
      def multiCdnLocationId: Output[String] = output.map(_.multiCdnLocationId)
      def trafficTypes: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudwrapperLocationsLocationTrafficType]]] = output.map(_.trafficTypes)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudwrapperLocationsLocation]])
      def locationId: Output[Option[Int]] = output.map(_.map(_.locationId))
      def locationName: Output[Option[String]] = output.map(_.map(_.locationName))
      def multiCdnLocationId: Output[Option[String]] = output.map(_.map(_.multiCdnLocationId))
      def trafficTypes: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetCloudwrapperLocationsLocationTrafficType]]] = output.map(_.flatMap(_.trafficTypes))


