package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudwrapperLocationsLocationTrafficType private(
  locationId: String,
  trafficType: String,
  trafficTypeId: Int
) derives Decoder

object GetCloudwrapperLocationsLocationTrafficType:
  given outputOps: {} with
    extension(output: Output[GetCloudwrapperLocationsLocationTrafficType])
      def locationId: Output[String] = output.map(_.locationId)
      def trafficType: Output[String] = output.map(_.trafficType)
      def trafficTypeId: Output[Int] = output.map(_.trafficTypeId)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudwrapperLocationsLocationTrafficType]])
      def locationId: Output[Option[String]] = output.map(_.map(_.locationId))
      def trafficType: Output[Option[String]] = output.map(_.map(_.trafficType))
      def trafficTypeId: Output[Option[Int]] = output.map(_.map(_.trafficTypeId))


