package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetCloudwrapperPropertiesProperty private(
  contractId: String,
  groupId: Int,
  propertyId: Int,
  propertyName: String,
  `type`: String
) derives Decoder

object GetCloudwrapperPropertiesProperty:
  given outputOps: {} with
    extension(output: Output[GetCloudwrapperPropertiesProperty])
      def contractId: Output[String] = output.map(_.contractId)
      def groupId: Output[Int] = output.map(_.groupId)
      def propertyId: Output[Int] = output.map(_.propertyId)
      def propertyName: Output[String] = output.map(_.propertyName)
      def `type`: Output[String] = output.map(_.`type`)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetCloudwrapperPropertiesProperty]])
      def contractId: Output[Option[String]] = output.map(_.map(_.contractId))
      def groupId: Output[Option[Int]] = output.map(_.map(_.groupId))
      def propertyId: Output[Option[Int]] = output.map(_.map(_.propertyId))
      def propertyName: Output[Option[String]] = output.map(_.map(_.propertyName))
      def `type`: Output[Option[String]] = output.map(_.map(_.`type`))


