package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetContractsContract private(
  contractId: String,
  contractTypeName: String
) derives Decoder

object GetContractsContract:
  given outputOps: {} with
    extension(output: Output[GetContractsContract])
      def contractId: Output[String] = output.map(_.contractId)
      def contractTypeName: Output[String] = output.map(_.contractTypeName)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetContractsContract]])
      def contractId: Output[Option[String]] = output.map(_.map(_.contractId))
      def contractTypeName: Output[Option[String]] = output.map(_.map(_.contractTypeName))


