package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetDatastreamActivationHistoryActivation private(
  modifiedBy: String,
  modifiedDate: String,
  status: String,
  streamId: Int,
  streamVersion: Int
) derives Decoder

object GetDatastreamActivationHistoryActivation:
  given outputOps: {} with
    extension(output: Output[GetDatastreamActivationHistoryActivation])
      def modifiedBy: Output[String] = output.map(_.modifiedBy)
      def modifiedDate: Output[String] = output.map(_.modifiedDate)
      def status: Output[String] = output.map(_.status)
      def streamId: Output[Int] = output.map(_.streamId)
      def streamVersion: Output[Int] = output.map(_.streamVersion)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetDatastreamActivationHistoryActivation]])
      def modifiedBy: Output[Option[String]] = output.map(_.map(_.modifiedBy))
      def modifiedDate: Output[Option[String]] = output.map(_.map(_.modifiedDate))
      def status: Output[Option[String]] = output.map(_.map(_.status))
      def streamId: Output[Option[Int]] = output.map(_.map(_.streamId))
      def streamVersion: Output[Option[Int]] = output.map(_.map(_.streamVersion))


