package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetDatastreamsStreamsDetail private(
  contractId: String,
  createdBy: String,
  createdDate: String,
  groupId: Int,
  latestVersion: Int,
  modifiedBy: String,
  modifiedDate: String,
  productId: String,
  properties: scala.collection.immutable.List[besom.api.akamai.outputs.GetDatastreamsStreamsDetailProperty],
  streamId: Int,
  streamName: String,
  streamStatus: String,
  streamVersion: Int
) derives Decoder

object GetDatastreamsStreamsDetail:
  given outputOps: {} with
    extension(output: Output[GetDatastreamsStreamsDetail])
      def contractId: Output[String] = output.map(_.contractId)
      def createdBy: Output[String] = output.map(_.createdBy)
      def createdDate: Output[String] = output.map(_.createdDate)
      def groupId: Output[Int] = output.map(_.groupId)
      def latestVersion: Output[Int] = output.map(_.latestVersion)
      def modifiedBy: Output[String] = output.map(_.modifiedBy)
      def modifiedDate: Output[String] = output.map(_.modifiedDate)
      def productId: Output[String] = output.map(_.productId)
      def properties: Output[scala.collection.immutable.List[besom.api.akamai.outputs.GetDatastreamsStreamsDetailProperty]] = output.map(_.properties)
      def streamId: Output[Int] = output.map(_.streamId)
      def streamName: Output[String] = output.map(_.streamName)
      def streamStatus: Output[String] = output.map(_.streamStatus)
      def streamVersion: Output[Int] = output.map(_.streamVersion)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetDatastreamsStreamsDetail]])
      def contractId: Output[Option[String]] = output.map(_.map(_.contractId))
      def createdBy: Output[Option[String]] = output.map(_.map(_.createdBy))
      def createdDate: Output[Option[String]] = output.map(_.map(_.createdDate))
      def groupId: Output[Option[Int]] = output.map(_.map(_.groupId))
      def latestVersion: Output[Option[Int]] = output.map(_.map(_.latestVersion))
      def modifiedBy: Output[Option[String]] = output.map(_.map(_.modifiedBy))
      def modifiedDate: Output[Option[String]] = output.map(_.map(_.modifiedDate))
      def productId: Output[Option[String]] = output.map(_.map(_.productId))
      def properties: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetDatastreamsStreamsDetailProperty]]] = output.map(_.map(_.properties))
      def streamId: Output[Option[Int]] = output.map(_.map(_.streamId))
      def streamName: Output[Option[String]] = output.map(_.map(_.streamName))
      def streamStatus: Output[Option[String]] = output.map(_.map(_.streamStatus))
      def streamVersion: Output[Option[Int]] = output.map(_.map(_.streamVersion))


