package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetGroupsGroup private(
  contractIds: scala.collection.immutable.List[String],
  groupId: String,
  groupName: String,
  parentGroupId: String
) derives Decoder

object GetGroupsGroup:
  given outputOps: {} with
    extension(output: Output[GetGroupsGroup])
      def contractIds: Output[scala.collection.immutable.List[String]] = output.map(_.contractIds)
      def groupId: Output[String] = output.map(_.groupId)
      def groupName: Output[String] = output.map(_.groupName)
      def parentGroupId: Output[String] = output.map(_.parentGroupId)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetGroupsGroup]])
      def contractIds: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.map(_.contractIds))
      def groupId: Output[Option[String]] = output.map(_.map(_.groupId))
      def groupName: Output[Option[String]] = output.map(_.map(_.groupName))
      def parentGroupId: Output[Option[String]] = output.map(_.map(_.parentGroupId))


