package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetGtmDatacentersDatacenter private(
  city: String,
  cloneOf: Int,
  cloudServerHostHeaderOverride: Boolean,
  cloudServerTargeting: Boolean,
  continent: String,
  country: String,
  datacenterId: Int,
  defaultLoadObjects: scala.collection.immutable.List[besom.api.akamai.outputs.GetGtmDatacentersDatacenterDefaultLoadObject],
  latitude: Double,
  links: scala.collection.immutable.List[besom.api.akamai.outputs.GetGtmDatacentersDatacenterLink],
  longitude: Double,
  nickname: String,
  scorePenalty: Int,
  servermonitorPool: String,
  stateOrProvince: String,
  virtual: Boolean
) derives Decoder

object GetGtmDatacentersDatacenter:
  given outputOps: {} with
    extension(output: Output[GetGtmDatacentersDatacenter])
      def city: Output[String] = output.map(_.city)
      def cloneOf: Output[Int] = output.map(_.cloneOf)
      def cloudServerHostHeaderOverride: Output[Boolean] = output.map(_.cloudServerHostHeaderOverride)
      def cloudServerTargeting: Output[Boolean] = output.map(_.cloudServerTargeting)
      def continent: Output[String] = output.map(_.continent)
      def country: Output[String] = output.map(_.country)
      def datacenterId: Output[Int] = output.map(_.datacenterId)
      def defaultLoadObjects: Output[scala.collection.immutable.List[besom.api.akamai.outputs.GetGtmDatacentersDatacenterDefaultLoadObject]] = output.map(_.defaultLoadObjects)
      def latitude: Output[Double] = output.map(_.latitude)
      def links: Output[scala.collection.immutable.List[besom.api.akamai.outputs.GetGtmDatacentersDatacenterLink]] = output.map(_.links)
      def longitude: Output[Double] = output.map(_.longitude)
      def nickname: Output[String] = output.map(_.nickname)
      def scorePenalty: Output[Int] = output.map(_.scorePenalty)
      def servermonitorPool: Output[String] = output.map(_.servermonitorPool)
      def stateOrProvince: Output[String] = output.map(_.stateOrProvince)
      def virtual: Output[Boolean] = output.map(_.virtual)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetGtmDatacentersDatacenter]])
      def city: Output[Option[String]] = output.map(_.map(_.city))
      def cloneOf: Output[Option[Int]] = output.map(_.map(_.cloneOf))
      def cloudServerHostHeaderOverride: Output[Option[Boolean]] = output.map(_.map(_.cloudServerHostHeaderOverride))
      def cloudServerTargeting: Output[Option[Boolean]] = output.map(_.map(_.cloudServerTargeting))
      def continent: Output[Option[String]] = output.map(_.map(_.continent))
      def country: Output[Option[String]] = output.map(_.map(_.country))
      def datacenterId: Output[Option[Int]] = output.map(_.map(_.datacenterId))
      def defaultLoadObjects: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetGtmDatacentersDatacenterDefaultLoadObject]]] = output.map(_.map(_.defaultLoadObjects))
      def latitude: Output[Option[Double]] = output.map(_.map(_.latitude))
      def links: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetGtmDatacentersDatacenterLink]]] = output.map(_.map(_.links))
      def longitude: Output[Option[Double]] = output.map(_.map(_.longitude))
      def nickname: Output[Option[String]] = output.map(_.map(_.nickname))
      def scorePenalty: Output[Option[Int]] = output.map(_.map(_.scorePenalty))
      def servermonitorPool: Output[Option[String]] = output.map(_.map(_.servermonitorPool))
      def stateOrProvince: Output[Option[String]] = output.map(_.map(_.stateOrProvince))
      def virtual: Output[Option[Boolean]] = output.map(_.map(_.virtual))


