package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetIamGrantableRolesGrantableRole private(
  description: String,
  grantedRoleId: Int,
  name: String
) derives Decoder

object GetIamGrantableRolesGrantableRole:
  given outputOps: {} with
    extension(output: Output[GetIamGrantableRolesGrantableRole])
      def description: Output[String] = output.map(_.description)
      def grantedRoleId: Output[Int] = output.map(_.grantedRoleId)
      def name: Output[String] = output.map(_.name)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetIamGrantableRolesGrantableRole]])
      def description: Output[Option[String]] = output.map(_.map(_.description))
      def grantedRoleId: Output[Option[Int]] = output.map(_.map(_.grantedRoleId))
      def name: Output[Option[String]] = output.map(_.map(_.name))


