package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetIamRolesRole private(
  createdBy: String,
  description: String,
  modifiedBy: String,
  name: String,
  roleId: String,
  timeCreated: String,
  timeModified: String,
  `type`: String
) derives Decoder

object GetIamRolesRole:
  given outputOps: {} with
    extension(output: Output[GetIamRolesRole])
      def createdBy: Output[String] = output.map(_.createdBy)
      def description: Output[String] = output.map(_.description)
      def modifiedBy: Output[String] = output.map(_.modifiedBy)
      def name: Output[String] = output.map(_.name)
      def roleId: Output[String] = output.map(_.roleId)
      def timeCreated: Output[String] = output.map(_.timeCreated)
      def timeModified: Output[String] = output.map(_.timeModified)
      def `type`: Output[String] = output.map(_.`type`)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetIamRolesRole]])
      def createdBy: Output[Option[String]] = output.map(_.map(_.createdBy))
      def description: Output[Option[String]] = output.map(_.map(_.description))
      def modifiedBy: Output[Option[String]] = output.map(_.map(_.modifiedBy))
      def name: Output[Option[String]] = output.map(_.map(_.name))
      def roleId: Output[Option[String]] = output.map(_.map(_.roleId))
      def timeCreated: Output[Option[String]] = output.map(_.map(_.timeCreated))
      def timeModified: Output[Option[String]] = output.map(_.map(_.timeModified))
      def `type`: Output[Option[String]] = output.map(_.map(_.`type`))


