package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetImagingPolicyImagePolicy private(
  breakpoints: Option[besom.api.akamai.outputs.GetImagingPolicyImagePolicyBreakpoints],
  hosts: Option[scala.collection.immutable.List[String]],
  output: Option[besom.api.akamai.outputs.GetImagingPolicyImagePolicyOutput],
  postBreakpointTransformations: Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetImagingPolicyImagePolicyPostBreakpointTransformation]],
  rolloutDuration: Option[String],
  transformations: Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetImagingPolicyImagePolicyTransformation]],
  variables: Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetImagingPolicyImagePolicyVariable]]
) derives Decoder

object GetImagingPolicyImagePolicy:
  given outputOps: {} with
    extension(output: Output[GetImagingPolicyImagePolicy])
      def breakpoints: Output[Option[besom.api.akamai.outputs.GetImagingPolicyImagePolicyBreakpoints]] = output.map(_.breakpoints)
      def hosts: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.hosts)
      def output: Output[Option[besom.api.akamai.outputs.GetImagingPolicyImagePolicyOutput]] = output.map(_.output)
      def postBreakpointTransformations: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetImagingPolicyImagePolicyPostBreakpointTransformation]]] = output.map(_.postBreakpointTransformations)
      def rolloutDuration: Output[Option[String]] = output.map(_.rolloutDuration)
      def transformations: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetImagingPolicyImagePolicyTransformation]]] = output.map(_.transformations)
      def variables: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetImagingPolicyImagePolicyVariable]]] = output.map(_.variables)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetImagingPolicyImagePolicy]])
      def breakpoints: Output[Option[besom.api.akamai.outputs.GetImagingPolicyImagePolicyBreakpoints]] = output.map(_.flatMap(_.breakpoints))
      def hosts: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.hosts))
      def output: Output[Option[besom.api.akamai.outputs.GetImagingPolicyImagePolicyOutput]] = output.map(_.flatMap(_.output))
      def postBreakpointTransformations: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetImagingPolicyImagePolicyPostBreakpointTransformation]]] = output.map(_.flatMap(_.postBreakpointTransformations))
      def rolloutDuration: Output[Option[String]] = output.map(_.flatMap(_.rolloutDuration))
      def transformations: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetImagingPolicyImagePolicyTransformation]]] = output.map(_.flatMap(_.transformations))
      def variables: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetImagingPolicyImagePolicyVariable]]] = output.map(_.flatMap(_.variables))


