package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetImagingPolicyImagePolicyOutput private(
  adaptiveQuality: Option[String],
  allowedFormats: Option[scala.collection.immutable.List[String]],
  forcedFormats: Option[scala.collection.immutable.List[String]],
  perceptualQuality: Option[String],
  perceptualQualityFloor: Option[String],
  perceptualQualityVar: Option[String],
  quality: Option[String],
  qualityVar: Option[String]
) derives Decoder

object GetImagingPolicyImagePolicyOutput:
  given outputOps: {} with
    extension(output: Output[GetImagingPolicyImagePolicyOutput])
      def adaptiveQuality: Output[Option[String]] = output.map(_.adaptiveQuality)
      def allowedFormats: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.allowedFormats)
      def forcedFormats: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.forcedFormats)
      def perceptualQuality: Output[Option[String]] = output.map(_.perceptualQuality)
      def perceptualQualityFloor: Output[Option[String]] = output.map(_.perceptualQualityFloor)
      def perceptualQualityVar: Output[Option[String]] = output.map(_.perceptualQualityVar)
      def quality: Output[Option[String]] = output.map(_.quality)
      def qualityVar: Output[Option[String]] = output.map(_.qualityVar)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetImagingPolicyImagePolicyOutput]])
      def adaptiveQuality: Output[Option[String]] = output.map(_.flatMap(_.adaptiveQuality))
      def allowedFormats: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.allowedFormats))
      def forcedFormats: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.forcedFormats))
      def perceptualQuality: Output[Option[String]] = output.map(_.flatMap(_.perceptualQuality))
      def perceptualQualityFloor: Output[Option[String]] = output.map(_.flatMap(_.perceptualQualityFloor))
      def perceptualQualityVar: Output[Option[String]] = output.map(_.flatMap(_.perceptualQualityVar))
      def quality: Output[Option[String]] = output.map(_.flatMap(_.quality))
      def qualityVar: Output[Option[String]] = output.map(_.flatMap(_.qualityVar))


