package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetImagingPolicyImagePolicyTransformationAppend private(
  gravity: Option[String],
  gravityPriority: Option[String],
  gravityPriorityVar: Option[String],
  gravityVar: Option[String],
  image: besom.api.akamai.outputs.GetImagingPolicyImagePolicyTransformationAppendImage,
  preserveMinorDimension: Option[String],
  preserveMinorDimensionVar: Option[String]
) derives Decoder

object GetImagingPolicyImagePolicyTransformationAppend:
  given outputOps: {} with
    extension(output: Output[GetImagingPolicyImagePolicyTransformationAppend])
      def gravity: Output[Option[String]] = output.map(_.gravity)
      def gravityPriority: Output[Option[String]] = output.map(_.gravityPriority)
      def gravityPriorityVar: Output[Option[String]] = output.map(_.gravityPriorityVar)
      def gravityVar: Output[Option[String]] = output.map(_.gravityVar)
      def image: Output[besom.api.akamai.outputs.GetImagingPolicyImagePolicyTransformationAppendImage] = output.map(_.image)
      def preserveMinorDimension: Output[Option[String]] = output.map(_.preserveMinorDimension)
      def preserveMinorDimensionVar: Output[Option[String]] = output.map(_.preserveMinorDimensionVar)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetImagingPolicyImagePolicyTransformationAppend]])
      def gravity: Output[Option[String]] = output.map(_.flatMap(_.gravity))
      def gravityPriority: Output[Option[String]] = output.map(_.flatMap(_.gravityPriority))
      def gravityPriorityVar: Output[Option[String]] = output.map(_.flatMap(_.gravityPriorityVar))
      def gravityVar: Output[Option[String]] = output.map(_.flatMap(_.gravityVar))
      def image: Output[Option[besom.api.akamai.outputs.GetImagingPolicyImagePolicyTransformationAppendImage]] = output.map(_.map(_.image))
      def preserveMinorDimension: Output[Option[String]] = output.map(_.flatMap(_.preserveMinorDimension))
      def preserveMinorDimensionVar: Output[Option[String]] = output.map(_.flatMap(_.preserveMinorDimensionVar))


