package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetImagingPolicyImagePolicyTransformationComposite private(
  gravity: Option[String],
  gravityVar: Option[String],
  image: besom.api.akamai.outputs.GetImagingPolicyImagePolicyTransformationCompositeImage,
  placement: Option[String],
  placementVar: Option[String],
  scale: Option[String],
  scaleDimension: Option[String],
  scaleDimensionVar: Option[String],
  scaleVar: Option[String],
  xPosition: Option[String],
  xPositionVar: Option[String],
  yPosition: Option[String],
  yPositionVar: Option[String]
) derives Decoder

object GetImagingPolicyImagePolicyTransformationComposite:
  given outputOps: {} with
    extension(output: Output[GetImagingPolicyImagePolicyTransformationComposite])
      def gravity: Output[Option[String]] = output.map(_.gravity)
      def gravityVar: Output[Option[String]] = output.map(_.gravityVar)
      def image: Output[besom.api.akamai.outputs.GetImagingPolicyImagePolicyTransformationCompositeImage] = output.map(_.image)
      def placement: Output[Option[String]] = output.map(_.placement)
      def placementVar: Output[Option[String]] = output.map(_.placementVar)
      def scale: Output[Option[String]] = output.map(_.scale)
      def scaleDimension: Output[Option[String]] = output.map(_.scaleDimension)
      def scaleDimensionVar: Output[Option[String]] = output.map(_.scaleDimensionVar)
      def scaleVar: Output[Option[String]] = output.map(_.scaleVar)
      def xPosition: Output[Option[String]] = output.map(_.xPosition)
      def xPositionVar: Output[Option[String]] = output.map(_.xPositionVar)
      def yPosition: Output[Option[String]] = output.map(_.yPosition)
      def yPositionVar: Output[Option[String]] = output.map(_.yPositionVar)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetImagingPolicyImagePolicyTransformationComposite]])
      def gravity: Output[Option[String]] = output.map(_.flatMap(_.gravity))
      def gravityVar: Output[Option[String]] = output.map(_.flatMap(_.gravityVar))
      def image: Output[Option[besom.api.akamai.outputs.GetImagingPolicyImagePolicyTransformationCompositeImage]] = output.map(_.map(_.image))
      def placement: Output[Option[String]] = output.map(_.flatMap(_.placement))
      def placementVar: Output[Option[String]] = output.map(_.flatMap(_.placementVar))
      def scale: Output[Option[String]] = output.map(_.flatMap(_.scale))
      def scaleDimension: Output[Option[String]] = output.map(_.flatMap(_.scaleDimension))
      def scaleDimensionVar: Output[Option[String]] = output.map(_.flatMap(_.scaleDimensionVar))
      def scaleVar: Output[Option[String]] = output.map(_.flatMap(_.scaleVar))
      def xPosition: Output[Option[String]] = output.map(_.flatMap(_.xPosition))
      def xPositionVar: Output[Option[String]] = output.map(_.flatMap(_.xPositionVar))
      def yPosition: Output[Option[String]] = output.map(_.flatMap(_.yPosition))
      def yPositionVar: Output[Option[String]] = output.map(_.flatMap(_.yPositionVar))


