package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetImagingPolicyImagePolicyTransformationContrast private(
  brightness: Option[String],
  brightnessVar: Option[String],
  contrast: Option[String],
  contrastVar: Option[String]
) derives Decoder

object GetImagingPolicyImagePolicyTransformationContrast:
  given outputOps: {} with
    extension(output: Output[GetImagingPolicyImagePolicyTransformationContrast])
      def brightness: Output[Option[String]] = output.map(_.brightness)
      def brightnessVar: Output[Option[String]] = output.map(_.brightnessVar)
      def contrast: Output[Option[String]] = output.map(_.contrast)
      def contrastVar: Output[Option[String]] = output.map(_.contrastVar)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetImagingPolicyImagePolicyTransformationContrast]])
      def brightness: Output[Option[String]] = output.map(_.flatMap(_.brightness))
      def brightnessVar: Output[Option[String]] = output.map(_.flatMap(_.brightnessVar))
      def contrast: Output[Option[String]] = output.map(_.flatMap(_.contrast))
      def contrastVar: Output[Option[String]] = output.map(_.flatMap(_.contrastVar))


