package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetImagingPolicyImagePolicyTransformationHsv private(
  hue: Option[String],
  hueVar: Option[String],
  saturation: Option[String],
  saturationVar: Option[String],
  value: Option[String],
  valueVar: Option[String]
) derives Decoder

object GetImagingPolicyImagePolicyTransformationHsv:
  given outputOps: {} with
    extension(output: Output[GetImagingPolicyImagePolicyTransformationHsv])
      def hue: Output[Option[String]] = output.map(_.hue)
      def hueVar: Output[Option[String]] = output.map(_.hueVar)
      def saturation: Output[Option[String]] = output.map(_.saturation)
      def saturationVar: Output[Option[String]] = output.map(_.saturationVar)
      def value: Output[Option[String]] = output.map(_.value)
      def valueVar: Output[Option[String]] = output.map(_.valueVar)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetImagingPolicyImagePolicyTransformationHsv]])
      def hue: Output[Option[String]] = output.map(_.flatMap(_.hue))
      def hueVar: Output[Option[String]] = output.map(_.flatMap(_.hueVar))
      def saturation: Output[Option[String]] = output.map(_.flatMap(_.saturation))
      def saturationVar: Output[Option[String]] = output.map(_.flatMap(_.saturationVar))
      def value: Output[Option[String]] = output.map(_.flatMap(_.value))
      def valueVar: Output[Option[String]] = output.map(_.flatMap(_.valueVar))


