package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetImagingPolicyImagePolicyTransformationScale private(
  height: Option[String],
  heightVar: Option[String],
  width: Option[String],
  widthVar: Option[String]
) derives Decoder

object GetImagingPolicyImagePolicyTransformationScale:
  given outputOps: {} with
    extension(output: Output[GetImagingPolicyImagePolicyTransformationScale])
      def height: Output[Option[String]] = output.map(_.height)
      def heightVar: Output[Option[String]] = output.map(_.heightVar)
      def width: Output[Option[String]] = output.map(_.width)
      def widthVar: Output[Option[String]] = output.map(_.widthVar)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetImagingPolicyImagePolicyTransformationScale]])
      def height: Output[Option[String]] = output.map(_.flatMap(_.height))
      def heightVar: Output[Option[String]] = output.map(_.flatMap(_.heightVar))
      def width: Output[Option[String]] = output.map(_.flatMap(_.width))
      def widthVar: Output[Option[String]] = output.map(_.flatMap(_.widthVar))


