package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetImagingPolicyImagePolicyTransformationUnsharpMask private(
  gain: Option[String],
  gainVar: Option[String],
  sigma: Option[String],
  sigmaVar: Option[String],
  threshold: Option[String],
  thresholdVar: Option[String]
) derives Decoder

object GetImagingPolicyImagePolicyTransformationUnsharpMask:
  given outputOps: {} with
    extension(output: Output[GetImagingPolicyImagePolicyTransformationUnsharpMask])
      def gain: Output[Option[String]] = output.map(_.gain)
      def gainVar: Output[Option[String]] = output.map(_.gainVar)
      def sigma: Output[Option[String]] = output.map(_.sigma)
      def sigmaVar: Output[Option[String]] = output.map(_.sigmaVar)
      def threshold: Output[Option[String]] = output.map(_.threshold)
      def thresholdVar: Output[Option[String]] = output.map(_.thresholdVar)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetImagingPolicyImagePolicyTransformationUnsharpMask]])
      def gain: Output[Option[String]] = output.map(_.flatMap(_.gain))
      def gainVar: Output[Option[String]] = output.map(_.flatMap(_.gainVar))
      def sigma: Output[Option[String]] = output.map(_.flatMap(_.sigma))
      def sigmaVar: Output[Option[String]] = output.map(_.flatMap(_.sigmaVar))
      def threshold: Output[Option[String]] = output.map(_.flatMap(_.threshold))
      def thresholdVar: Output[Option[String]] = output.map(_.flatMap(_.thresholdVar))


