package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetImagingPolicyVideoPolicy private(
  breakpoints: Option[besom.api.akamai.outputs.GetImagingPolicyVideoPolicyBreakpoints],
  hosts: Option[scala.collection.immutable.List[String]],
  output: Option[besom.api.akamai.outputs.GetImagingPolicyVideoPolicyOutput],
  rolloutDuration: Option[String],
  variables: Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetImagingPolicyVideoPolicyVariable]]
) derives Decoder

object GetImagingPolicyVideoPolicy:
  given outputOps: {} with
    extension(output: Output[GetImagingPolicyVideoPolicy])
      def breakpoints: Output[Option[besom.api.akamai.outputs.GetImagingPolicyVideoPolicyBreakpoints]] = output.map(_.breakpoints)
      def hosts: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.hosts)
      def output: Output[Option[besom.api.akamai.outputs.GetImagingPolicyVideoPolicyOutput]] = output.map(_.output)
      def rolloutDuration: Output[Option[String]] = output.map(_.rolloutDuration)
      def variables: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetImagingPolicyVideoPolicyVariable]]] = output.map(_.variables)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetImagingPolicyVideoPolicy]])
      def breakpoints: Output[Option[besom.api.akamai.outputs.GetImagingPolicyVideoPolicyBreakpoints]] = output.map(_.flatMap(_.breakpoints))
      def hosts: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.hosts))
      def output: Output[Option[besom.api.akamai.outputs.GetImagingPolicyVideoPolicyOutput]] = output.map(_.flatMap(_.output))
      def rolloutDuration: Output[Option[String]] = output.map(_.flatMap(_.rolloutDuration))
      def variables: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GetImagingPolicyVideoPolicyVariable]]] = output.map(_.flatMap(_.variables))


