package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetImagingPolicyVideoPolicyOutput private(
  perceptualQuality: Option[String],
  perceptualQualityVar: Option[String],
  placeholderVideoUrl: Option[String],
  placeholderVideoUrlVar: Option[String],
  videoAdaptiveQuality: Option[String],
  videoAdaptiveQualityVar: Option[String]
) derives Decoder

object GetImagingPolicyVideoPolicyOutput:
  given outputOps: {} with
    extension(output: Output[GetImagingPolicyVideoPolicyOutput])
      def perceptualQuality: Output[Option[String]] = output.map(_.perceptualQuality)
      def perceptualQualityVar: Output[Option[String]] = output.map(_.perceptualQualityVar)
      def placeholderVideoUrl: Output[Option[String]] = output.map(_.placeholderVideoUrl)
      def placeholderVideoUrlVar: Output[Option[String]] = output.map(_.placeholderVideoUrlVar)
      def videoAdaptiveQuality: Output[Option[String]] = output.map(_.videoAdaptiveQuality)
      def videoAdaptiveQualityVar: Output[Option[String]] = output.map(_.videoAdaptiveQualityVar)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetImagingPolicyVideoPolicyOutput]])
      def perceptualQuality: Output[Option[String]] = output.map(_.flatMap(_.perceptualQuality))
      def perceptualQualityVar: Output[Option[String]] = output.map(_.flatMap(_.perceptualQualityVar))
      def placeholderVideoUrl: Output[Option[String]] = output.map(_.flatMap(_.placeholderVideoUrl))
      def placeholderVideoUrlVar: Output[Option[String]] = output.map(_.flatMap(_.placeholderVideoUrlVar))
      def videoAdaptiveQuality: Output[Option[String]] = output.map(_.flatMap(_.videoAdaptiveQuality))
      def videoAdaptiveQualityVar: Output[Option[String]] = output.map(_.flatMap(_.videoAdaptiveQualityVar))


