package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPropertiesProperty private(
  contractId: String,
  groupId: String,
  latestVersion: Int,
  note: String,
  productId: String,
  productionVersion: Int,
  propertyId: String,
  propertyName: String,
  ruleFormat: String,
  stagingVersion: Int
) derives Decoder

object GetPropertiesProperty:
  given outputOps: {} with
    extension(output: Output[GetPropertiesProperty])
      def contractId: Output[String] = output.map(_.contractId)
      def groupId: Output[String] = output.map(_.groupId)
      def latestVersion: Output[Int] = output.map(_.latestVersion)
      def note: Output[String] = output.map(_.note)
      def productId: Output[String] = output.map(_.productId)
      def productionVersion: Output[Int] = output.map(_.productionVersion)
      def propertyId: Output[String] = output.map(_.propertyId)
      def propertyName: Output[String] = output.map(_.propertyName)
      def ruleFormat: Output[String] = output.map(_.ruleFormat)
      def stagingVersion: Output[Int] = output.map(_.stagingVersion)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPropertiesProperty]])
      def contractId: Output[Option[String]] = output.map(_.map(_.contractId))
      def groupId: Output[Option[String]] = output.map(_.map(_.groupId))
      def latestVersion: Output[Option[Int]] = output.map(_.map(_.latestVersion))
      def note: Output[Option[String]] = output.map(_.map(_.note))
      def productId: Output[Option[String]] = output.map(_.map(_.productId))
      def productionVersion: Output[Option[Int]] = output.map(_.map(_.productionVersion))
      def propertyId: Output[Option[String]] = output.map(_.map(_.propertyId))
      def propertyName: Output[Option[String]] = output.map(_.map(_.propertyName))
      def ruleFormat: Output[Option[String]] = output.map(_.map(_.ruleFormat))
      def stagingVersion: Output[Option[Int]] = output.map(_.map(_.stagingVersion))


