package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPropertiesSearchProperty private(
  accountId: String,
  assetId: String,
  contractId: String,
  edgeHostname: String,
  groupId: String,
  hostname: String,
  productionStatus: String,
  propertyId: String,
  propertyName: String,
  propertyVersion: Int,
  stagingStatus: String,
  updatedByUser: String,
  updatedDate: String
) derives Decoder

object GetPropertiesSearchProperty:
  given outputOps: {} with
    extension(output: Output[GetPropertiesSearchProperty])
      def accountId: Output[String] = output.map(_.accountId)
      def assetId: Output[String] = output.map(_.assetId)
      def contractId: Output[String] = output.map(_.contractId)
      def edgeHostname: Output[String] = output.map(_.edgeHostname)
      def groupId: Output[String] = output.map(_.groupId)
      def hostname: Output[String] = output.map(_.hostname)
      def productionStatus: Output[String] = output.map(_.productionStatus)
      def propertyId: Output[String] = output.map(_.propertyId)
      def propertyName: Output[String] = output.map(_.propertyName)
      def propertyVersion: Output[Int] = output.map(_.propertyVersion)
      def stagingStatus: Output[String] = output.map(_.stagingStatus)
      def updatedByUser: Output[String] = output.map(_.updatedByUser)
      def updatedDate: Output[String] = output.map(_.updatedDate)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPropertiesSearchProperty]])
      def accountId: Output[Option[String]] = output.map(_.map(_.accountId))
      def assetId: Output[Option[String]] = output.map(_.map(_.assetId))
      def contractId: Output[Option[String]] = output.map(_.map(_.contractId))
      def edgeHostname: Output[Option[String]] = output.map(_.map(_.edgeHostname))
      def groupId: Output[Option[String]] = output.map(_.map(_.groupId))
      def hostname: Output[Option[String]] = output.map(_.map(_.hostname))
      def productionStatus: Output[Option[String]] = output.map(_.map(_.productionStatus))
      def propertyId: Output[Option[String]] = output.map(_.map(_.propertyId))
      def propertyName: Output[Option[String]] = output.map(_.map(_.propertyName))
      def propertyVersion: Output[Option[Int]] = output.map(_.map(_.propertyVersion))
      def stagingStatus: Output[Option[String]] = output.map(_.map(_.stagingStatus))
      def updatedByUser: Output[Option[String]] = output.map(_.map(_.updatedByUser))
      def updatedDate: Output[Option[String]] = output.map(_.map(_.updatedDate))


