package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPropertyHostnamesHostnameCertStatus private(
  hostname: String,
  productionStatus: String,
  stagingStatus: String,
  target: String
) derives Decoder

object GetPropertyHostnamesHostnameCertStatus:
  given outputOps: {} with
    extension(output: Output[GetPropertyHostnamesHostnameCertStatus])
      def hostname: Output[String] = output.map(_.hostname)
      def productionStatus: Output[String] = output.map(_.productionStatus)
      def stagingStatus: Output[String] = output.map(_.stagingStatus)
      def target: Output[String] = output.map(_.target)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPropertyHostnamesHostnameCertStatus]])
      def hostname: Output[Option[String]] = output.map(_.map(_.hostname))
      def productionStatus: Output[Option[String]] = output.map(_.map(_.productionStatus))
      def stagingStatus: Output[Option[String]] = output.map(_.map(_.stagingStatus))
      def target: Output[Option[String]] = output.map(_.map(_.target))


