package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPropertyIncludeParentsParent private(
  id: String,
  isIncludeUsedInProductionVersion: Boolean,
  isIncludeUsedInStagingVersion: Boolean,
  name: String,
  productionVersion: String,
  stagingVersion: String
) derives Decoder

object GetPropertyIncludeParentsParent:
  given outputOps: {} with
    extension(output: Output[GetPropertyIncludeParentsParent])
      def id: Output[String] = output.map(_.id)
      def isIncludeUsedInProductionVersion: Output[Boolean] = output.map(_.isIncludeUsedInProductionVersion)
      def isIncludeUsedInStagingVersion: Output[Boolean] = output.map(_.isIncludeUsedInStagingVersion)
      def name: Output[String] = output.map(_.name)
      def productionVersion: Output[String] = output.map(_.productionVersion)
      def stagingVersion: Output[String] = output.map(_.stagingVersion)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPropertyIncludeParentsParent]])
      def id: Output[Option[String]] = output.map(_.map(_.id))
      def isIncludeUsedInProductionVersion: Output[Option[Boolean]] = output.map(_.map(_.isIncludeUsedInProductionVersion))
      def isIncludeUsedInStagingVersion: Output[Option[Boolean]] = output.map(_.map(_.isIncludeUsedInStagingVersion))
      def name: Output[Option[String]] = output.map(_.map(_.name))
      def productionVersion: Output[Option[String]] = output.map(_.map(_.productionVersion))
      def stagingVersion: Output[Option[String]] = output.map(_.map(_.stagingVersion))


