package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPropertyIncludesInclude private(
  id: String,
  latestVersion: Int,
  name: String,
  productionVersion: String,
  stagingVersion: String,
  `type`: String
) derives Decoder

object GetPropertyIncludesInclude:
  given outputOps: {} with
    extension(output: Output[GetPropertyIncludesInclude])
      def id: Output[String] = output.map(_.id)
      def latestVersion: Output[Int] = output.map(_.latestVersion)
      def name: Output[String] = output.map(_.name)
      def productionVersion: Output[String] = output.map(_.productionVersion)
      def stagingVersion: Output[String] = output.map(_.stagingVersion)
      def `type`: Output[String] = output.map(_.`type`)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPropertyIncludesInclude]])
      def id: Output[Option[String]] = output.map(_.map(_.id))
      def latestVersion: Output[Option[Int]] = output.map(_.map(_.latestVersion))
      def name: Output[Option[String]] = output.map(_.map(_.name))
      def productionVersion: Output[Option[String]] = output.map(_.map(_.productionVersion))
      def stagingVersion: Output[Option[String]] = output.map(_.map(_.stagingVersion))
      def `type`: Output[Option[String]] = output.map(_.map(_.`type`))


