package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPropertyProductsProduct private(
  productId: String,
  productName: String
) derives Decoder

object GetPropertyProductsProduct:
  given outputOps: {} with
    extension(output: Output[GetPropertyProductsProduct])
      def productId: Output[String] = output.map(_.productId)
      def productName: Output[String] = output.map(_.productName)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPropertyProductsProduct]])
      def productId: Output[Option[String]] = output.map(_.map(_.productId))
      def productName: Output[Option[String]] = output.map(_.map(_.productName))


