package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPropertyRulesBuilderRulesV20230105BehaviorDcpRealTimeAuth private(
  extractHostname: Option[Boolean],
  extractJurisdiction: Option[Boolean],
  extractNamespace: Option[Boolean],
  hostnameClaim: Option[String],
  jurisdictionClaim: Option[String],
  locked: Option[Boolean],
  namespaceClaim: Option[String],
  templateUuid: Option[String],
  uuid: Option[String]
) derives Decoder

object GetPropertyRulesBuilderRulesV20230105BehaviorDcpRealTimeAuth:
  given outputOps: {} with
    extension(output: Output[GetPropertyRulesBuilderRulesV20230105BehaviorDcpRealTimeAuth])
      def extractHostname: Output[Option[Boolean]] = output.map(_.extractHostname)
      def extractJurisdiction: Output[Option[Boolean]] = output.map(_.extractJurisdiction)
      def extractNamespace: Output[Option[Boolean]] = output.map(_.extractNamespace)
      def hostnameClaim: Output[Option[String]] = output.map(_.hostnameClaim)
      def jurisdictionClaim: Output[Option[String]] = output.map(_.jurisdictionClaim)
      def locked: Output[Option[Boolean]] = output.map(_.locked)
      def namespaceClaim: Output[Option[String]] = output.map(_.namespaceClaim)
      def templateUuid: Output[Option[String]] = output.map(_.templateUuid)
      def uuid: Output[Option[String]] = output.map(_.uuid)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPropertyRulesBuilderRulesV20230105BehaviorDcpRealTimeAuth]])
      def extractHostname: Output[Option[Boolean]] = output.map(_.flatMap(_.extractHostname))
      def extractJurisdiction: Output[Option[Boolean]] = output.map(_.flatMap(_.extractJurisdiction))
      def extractNamespace: Output[Option[Boolean]] = output.map(_.flatMap(_.extractNamespace))
      def hostnameClaim: Output[Option[String]] = output.map(_.flatMap(_.hostnameClaim))
      def jurisdictionClaim: Output[Option[String]] = output.map(_.flatMap(_.jurisdictionClaim))
      def locked: Output[Option[Boolean]] = output.map(_.flatMap(_.locked))
      def namespaceClaim: Output[Option[String]] = output.map(_.flatMap(_.namespaceClaim))
      def templateUuid: Output[Option[String]] = output.map(_.flatMap(_.templateUuid))
      def uuid: Output[Option[String]] = output.map(_.flatMap(_.uuid))


