package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPropertyRulesBuilderRulesV20230530BehaviorDatastream private(
  beaconStreamTitle: Option[String],
  collectMidgressTraffic: Option[Boolean],
  datastreamIds: Option[String],
  enabled: Option[Boolean],
  locked: Option[Boolean],
  logEnabled: Option[Boolean],
  logStreamNames: Option[scala.collection.immutable.List[String]],
  logStreamTitle: Option[String],
  samplingPercentage: Option[Int],
  streamType: Option[String],
  templateUuid: Option[String],
  uuid: Option[String]
) derives Decoder

object GetPropertyRulesBuilderRulesV20230530BehaviorDatastream:
  given outputOps: {} with
    extension(output: Output[GetPropertyRulesBuilderRulesV20230530BehaviorDatastream])
      def beaconStreamTitle: Output[Option[String]] = output.map(_.beaconStreamTitle)
      def collectMidgressTraffic: Output[Option[Boolean]] = output.map(_.collectMidgressTraffic)
      def datastreamIds: Output[Option[String]] = output.map(_.datastreamIds)
      def enabled: Output[Option[Boolean]] = output.map(_.enabled)
      def locked: Output[Option[Boolean]] = output.map(_.locked)
      def logEnabled: Output[Option[Boolean]] = output.map(_.logEnabled)
      def logStreamNames: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.logStreamNames)
      def logStreamTitle: Output[Option[String]] = output.map(_.logStreamTitle)
      def samplingPercentage: Output[Option[Int]] = output.map(_.samplingPercentage)
      def streamType: Output[Option[String]] = output.map(_.streamType)
      def templateUuid: Output[Option[String]] = output.map(_.templateUuid)
      def uuid: Output[Option[String]] = output.map(_.uuid)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPropertyRulesBuilderRulesV20230530BehaviorDatastream]])
      def beaconStreamTitle: Output[Option[String]] = output.map(_.flatMap(_.beaconStreamTitle))
      def collectMidgressTraffic: Output[Option[Boolean]] = output.map(_.flatMap(_.collectMidgressTraffic))
      def datastreamIds: Output[Option[String]] = output.map(_.flatMap(_.datastreamIds))
      def enabled: Output[Option[Boolean]] = output.map(_.flatMap(_.enabled))
      def locked: Output[Option[Boolean]] = output.map(_.flatMap(_.locked))
      def logEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.logEnabled))
      def logStreamNames: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.logStreamNames))
      def logStreamTitle: Output[Option[String]] = output.map(_.flatMap(_.logStreamTitle))
      def samplingPercentage: Output[Option[Int]] = output.map(_.flatMap(_.samplingPercentage))
      def streamType: Output[Option[String]] = output.map(_.flatMap(_.streamType))
      def templateUuid: Output[Option[String]] = output.map(_.flatMap(_.templateUuid))
      def uuid: Output[Option[String]] = output.map(_.flatMap(_.uuid))


