package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPropertyRulesBuilderRulesV20230530BehaviorDownstreamCache private(
  allowBehavior: Option[String],
  behavior: Option[String],
  locked: Option[Boolean],
  sendHeaders: Option[String],
  sendPrivate: Option[Boolean],
  templateUuid: Option[String],
  ttl: Option[String],
  uuid: Option[String]
) derives Decoder

object GetPropertyRulesBuilderRulesV20230530BehaviorDownstreamCache:
  given outputOps: {} with
    extension(output: Output[GetPropertyRulesBuilderRulesV20230530BehaviorDownstreamCache])
      def allowBehavior: Output[Option[String]] = output.map(_.allowBehavior)
      def behavior: Output[Option[String]] = output.map(_.behavior)
      def locked: Output[Option[Boolean]] = output.map(_.locked)
      def sendHeaders: Output[Option[String]] = output.map(_.sendHeaders)
      def sendPrivate: Output[Option[Boolean]] = output.map(_.sendPrivate)
      def templateUuid: Output[Option[String]] = output.map(_.templateUuid)
      def ttl: Output[Option[String]] = output.map(_.ttl)
      def uuid: Output[Option[String]] = output.map(_.uuid)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPropertyRulesBuilderRulesV20230530BehaviorDownstreamCache]])
      def allowBehavior: Output[Option[String]] = output.map(_.flatMap(_.allowBehavior))
      def behavior: Output[Option[String]] = output.map(_.flatMap(_.behavior))
      def locked: Output[Option[Boolean]] = output.map(_.flatMap(_.locked))
      def sendHeaders: Output[Option[String]] = output.map(_.flatMap(_.sendHeaders))
      def sendPrivate: Output[Option[Boolean]] = output.map(_.flatMap(_.sendPrivate))
      def templateUuid: Output[Option[String]] = output.map(_.flatMap(_.templateUuid))
      def ttl: Output[Option[String]] = output.map(_.flatMap(_.ttl))
      def uuid: Output[Option[String]] = output.map(_.flatMap(_.uuid))


