package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPropertyRulesBuilderRulesV20230530BehaviorOriginCharacteristics private(
  accessKeyEncryptedStorage: Option[Boolean],
  adcTitle: Option[String],
  authenticationMethod: Option[String],
  authenticationMethodTitle: Option[String],
  awsAccessKeyId: Option[String],
  awsAccessKeyVersionGuid: Option[String],
  awsArRegion: Option[String],
  awsHost: Option[String],
  awsRegion: Option[String],
  awsSecretAccessKey: Option[String],
  awsService: Option[String],
  country: Option[String],
  customSignStrings: Option[scala.collection.immutable.List[String]],
  directConnectGeo: Option[String],
  encodingVersion: Option[Int],
  endPointService: Option[String],
  gcsAccessKeyVersionGuid: Option[String],
  gcsHmacKeyAccessId: Option[String],
  gcsHmacKeySecret: Option[String],
  hostnameTag: Option[Boolean],
  locked: Option[Boolean],
  mslkey: Option[String],
  mslname: Option[String],
  nonce: Option[String],
  originLocationTitle: Option[String],
  propertyIdTag: Option[Boolean],
  roleArn: Option[String],
  secretKey: Option[String],
  templateUuid: Option[String],
  useCustomSignString: Option[Boolean],
  uuid: Option[String]
) derives Decoder

object GetPropertyRulesBuilderRulesV20230530BehaviorOriginCharacteristics:
  given outputOps: {} with
    extension(output: Output[GetPropertyRulesBuilderRulesV20230530BehaviorOriginCharacteristics])
      def accessKeyEncryptedStorage: Output[Option[Boolean]] = output.map(_.accessKeyEncryptedStorage)
      def adcTitle: Output[Option[String]] = output.map(_.adcTitle)
      def authenticationMethod: Output[Option[String]] = output.map(_.authenticationMethod)
      def authenticationMethodTitle: Output[Option[String]] = output.map(_.authenticationMethodTitle)
      def awsAccessKeyId: Output[Option[String]] = output.map(_.awsAccessKeyId)
      def awsAccessKeyVersionGuid: Output[Option[String]] = output.map(_.awsAccessKeyVersionGuid)
      def awsArRegion: Output[Option[String]] = output.map(_.awsArRegion)
      def awsHost: Output[Option[String]] = output.map(_.awsHost)
      def awsRegion: Output[Option[String]] = output.map(_.awsRegion)
      def awsSecretAccessKey: Output[Option[String]] = output.map(_.awsSecretAccessKey)
      def awsService: Output[Option[String]] = output.map(_.awsService)
      def country: Output[Option[String]] = output.map(_.country)
      def customSignStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.customSignStrings)
      def directConnectGeo: Output[Option[String]] = output.map(_.directConnectGeo)
      def encodingVersion: Output[Option[Int]] = output.map(_.encodingVersion)
      def endPointService: Output[Option[String]] = output.map(_.endPointService)
      def gcsAccessKeyVersionGuid: Output[Option[String]] = output.map(_.gcsAccessKeyVersionGuid)
      def gcsHmacKeyAccessId: Output[Option[String]] = output.map(_.gcsHmacKeyAccessId)
      def gcsHmacKeySecret: Output[Option[String]] = output.map(_.gcsHmacKeySecret)
      def hostnameTag: Output[Option[Boolean]] = output.map(_.hostnameTag)
      def locked: Output[Option[Boolean]] = output.map(_.locked)
      def mslkey: Output[Option[String]] = output.map(_.mslkey)
      def mslname: Output[Option[String]] = output.map(_.mslname)
      def nonce: Output[Option[String]] = output.map(_.nonce)
      def originLocationTitle: Output[Option[String]] = output.map(_.originLocationTitle)
      def propertyIdTag: Output[Option[Boolean]] = output.map(_.propertyIdTag)
      def roleArn: Output[Option[String]] = output.map(_.roleArn)
      def secretKey: Output[Option[String]] = output.map(_.secretKey)
      def templateUuid: Output[Option[String]] = output.map(_.templateUuid)
      def useCustomSignString: Output[Option[Boolean]] = output.map(_.useCustomSignString)
      def uuid: Output[Option[String]] = output.map(_.uuid)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPropertyRulesBuilderRulesV20230530BehaviorOriginCharacteristics]])
      def accessKeyEncryptedStorage: Output[Option[Boolean]] = output.map(_.flatMap(_.accessKeyEncryptedStorage))
      def adcTitle: Output[Option[String]] = output.map(_.flatMap(_.adcTitle))
      def authenticationMethod: Output[Option[String]] = output.map(_.flatMap(_.authenticationMethod))
      def authenticationMethodTitle: Output[Option[String]] = output.map(_.flatMap(_.authenticationMethodTitle))
      def awsAccessKeyId: Output[Option[String]] = output.map(_.flatMap(_.awsAccessKeyId))
      def awsAccessKeyVersionGuid: Output[Option[String]] = output.map(_.flatMap(_.awsAccessKeyVersionGuid))
      def awsArRegion: Output[Option[String]] = output.map(_.flatMap(_.awsArRegion))
      def awsHost: Output[Option[String]] = output.map(_.flatMap(_.awsHost))
      def awsRegion: Output[Option[String]] = output.map(_.flatMap(_.awsRegion))
      def awsSecretAccessKey: Output[Option[String]] = output.map(_.flatMap(_.awsSecretAccessKey))
      def awsService: Output[Option[String]] = output.map(_.flatMap(_.awsService))
      def country: Output[Option[String]] = output.map(_.flatMap(_.country))
      def customSignStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.customSignStrings))
      def directConnectGeo: Output[Option[String]] = output.map(_.flatMap(_.directConnectGeo))
      def encodingVersion: Output[Option[Int]] = output.map(_.flatMap(_.encodingVersion))
      def endPointService: Output[Option[String]] = output.map(_.flatMap(_.endPointService))
      def gcsAccessKeyVersionGuid: Output[Option[String]] = output.map(_.flatMap(_.gcsAccessKeyVersionGuid))
      def gcsHmacKeyAccessId: Output[Option[String]] = output.map(_.flatMap(_.gcsHmacKeyAccessId))
      def gcsHmacKeySecret: Output[Option[String]] = output.map(_.flatMap(_.gcsHmacKeySecret))
      def hostnameTag: Output[Option[Boolean]] = output.map(_.flatMap(_.hostnameTag))
      def locked: Output[Option[Boolean]] = output.map(_.flatMap(_.locked))
      def mslkey: Output[Option[String]] = output.map(_.flatMap(_.mslkey))
      def mslname: Output[Option[String]] = output.map(_.flatMap(_.mslname))
      def nonce: Output[Option[String]] = output.map(_.flatMap(_.nonce))
      def originLocationTitle: Output[Option[String]] = output.map(_.flatMap(_.originLocationTitle))
      def propertyIdTag: Output[Option[Boolean]] = output.map(_.flatMap(_.propertyIdTag))
      def roleArn: Output[Option[String]] = output.map(_.flatMap(_.roleArn))
      def secretKey: Output[Option[String]] = output.map(_.flatMap(_.secretKey))
      def templateUuid: Output[Option[String]] = output.map(_.flatMap(_.templateUuid))
      def useCustomSignString: Output[Option[Boolean]] = output.map(_.flatMap(_.useCustomSignString))
      def uuid: Output[Option[String]] = output.map(_.flatMap(_.uuid))


