package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPropertyRulesTemplateTemplate private(
  templateData: String,
  templateDir: String
) derives Decoder

object GetPropertyRulesTemplateTemplate:
  given outputOps: {} with
    extension(output: Output[GetPropertyRulesTemplateTemplate])
      def templateData: Output[String] = output.map(_.templateData)
      def templateDir: Output[String] = output.map(_.templateDir)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPropertyRulesTemplateTemplate]])
      def templateData: Output[Option[String]] = output.map(_.map(_.templateData))
      def templateDir: Output[Option[String]] = output.map(_.map(_.templateDir))


