package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GtmAsmapAssignment private(
  asNumbers: scala.collection.immutable.List[Int],
  datacenterId: Int,
  nickname: String
) derives Decoder

object GtmAsmapAssignment:
  given outputOps: {} with
    extension(output: Output[GtmAsmapAssignment])
      def asNumbers: Output[scala.collection.immutable.List[Int]] = output.map(_.asNumbers)
      def datacenterId: Output[Int] = output.map(_.datacenterId)
      def nickname: Output[String] = output.map(_.nickname)

  given optionOutputOps: {} with
    extension(output: Output[Option[GtmAsmapAssignment]])
      def asNumbers: Output[Option[scala.collection.immutable.List[Int]]] = output.map(_.map(_.asNumbers))
      def datacenterId: Output[Option[Int]] = output.map(_.map(_.datacenterId))
      def nickname: Output[Option[String]] = output.map(_.map(_.nickname))


