package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GtmCidrmapAssignment private(
  blocks: Option[scala.collection.immutable.List[String]],
  datacenterId: Int,
  nickname: String
) derives Decoder

object GtmCidrmapAssignment:
  given outputOps: {} with
    extension(output: Output[GtmCidrmapAssignment])
      def blocks: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.blocks)
      def datacenterId: Output[Int] = output.map(_.datacenterId)
      def nickname: Output[String] = output.map(_.nickname)

  given optionOutputOps: {} with
    extension(output: Output[Option[GtmCidrmapAssignment]])
      def blocks: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.blocks))
      def datacenterId: Output[Option[Int]] = output.map(_.map(_.datacenterId))
      def nickname: Output[Option[String]] = output.map(_.map(_.nickname))


