package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GtmCidrmapDefaultDatacenter private(
  datacenterId: Int,
  nickname: Option[String]
) derives Decoder

object GtmCidrmapDefaultDatacenter:
  given outputOps: {} with
    extension(output: Output[GtmCidrmapDefaultDatacenter])
      def datacenterId: Output[Int] = output.map(_.datacenterId)
      def nickname: Output[Option[String]] = output.map(_.nickname)

  given optionOutputOps: {} with
    extension(output: Output[Option[GtmCidrmapDefaultDatacenter]])
      def datacenterId: Output[Option[Int]] = output.map(_.map(_.datacenterId))
      def nickname: Output[Option[String]] = output.map(_.flatMap(_.nickname))


