package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GtmDatacenterDefaultLoadObject private(
  loadObject: Option[String],
  loadObjectPort: Option[Int],
  loadServers: Option[scala.collection.immutable.List[String]]
) derives Decoder

object GtmDatacenterDefaultLoadObject:
  given outputOps: {} with
    extension(output: Output[GtmDatacenterDefaultLoadObject])
      def loadObject: Output[Option[String]] = output.map(_.loadObject)
      def loadObjectPort: Output[Option[Int]] = output.map(_.loadObjectPort)
      def loadServers: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.loadServers)

  given optionOutputOps: {} with
    extension(output: Output[Option[GtmDatacenterDefaultLoadObject]])
      def loadObject: Output[Option[String]] = output.map(_.flatMap(_.loadObject))
      def loadObjectPort: Output[Option[Int]] = output.map(_.flatMap(_.loadObjectPort))
      def loadServers: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.loadServers))


