package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GtmGeomapAssignment private(
  countries: Option[scala.collection.immutable.List[String]],
  datacenterId: Int,
  nickname: String
) derives Decoder

object GtmGeomapAssignment:
  given outputOps: {} with
    extension(output: Output[GtmGeomapAssignment])
      def countries: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.countries)
      def datacenterId: Output[Int] = output.map(_.datacenterId)
      def nickname: Output[String] = output.map(_.nickname)

  given optionOutputOps: {} with
    extension(output: Output[Option[GtmGeomapAssignment]])
      def countries: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.countries))
      def datacenterId: Output[Option[Int]] = output.map(_.map(_.datacenterId))
      def nickname: Output[Option[String]] = output.map(_.map(_.nickname))


