package besom.api.akamai.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GtmPropertyLivenessTest private(
  answersRequired: Option[Boolean],
  disableNonstandardPortWarning: Option[Boolean],
  disabled: Option[Boolean],
  errorPenalty: Option[Double],
  httpError3xx: Option[Boolean],
  httpError4xx: Option[Boolean],
  httpError5xx: Option[Boolean],
  httpHeaders: Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmPropertyLivenessTestHttpHeader]],
  name: String,
  peerCertificateVerification: Option[Boolean],
  recursionRequested: Option[Boolean],
  requestString: Option[String],
  resourceType: Option[String],
  responseString: Option[String],
  sslClientCertificate: Option[String],
  sslClientPrivateKey: Option[String],
  testInterval: Int,
  testObject: Option[String],
  testObjectPassword: Option[String],
  testObjectPort: Option[Int],
  testObjectProtocol: String,
  testObjectUsername: Option[String],
  testTimeout: Double,
  timeoutPenalty: Option[Double]
) derives Decoder

object GtmPropertyLivenessTest:
  given outputOps: {} with
    extension(output: Output[GtmPropertyLivenessTest])
      def answersRequired: Output[Option[Boolean]] = output.map(_.answersRequired)
      def disableNonstandardPortWarning: Output[Option[Boolean]] = output.map(_.disableNonstandardPortWarning)
      def disabled: Output[Option[Boolean]] = output.map(_.disabled)
      def errorPenalty: Output[Option[Double]] = output.map(_.errorPenalty)
      def httpError3xx: Output[Option[Boolean]] = output.map(_.httpError3xx)
      def httpError4xx: Output[Option[Boolean]] = output.map(_.httpError4xx)
      def httpError5xx: Output[Option[Boolean]] = output.map(_.httpError5xx)
      def httpHeaders: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmPropertyLivenessTestHttpHeader]]] = output.map(_.httpHeaders)
      def name: Output[String] = output.map(_.name)
      def peerCertificateVerification: Output[Option[Boolean]] = output.map(_.peerCertificateVerification)
      def recursionRequested: Output[Option[Boolean]] = output.map(_.recursionRequested)
      def requestString: Output[Option[String]] = output.map(_.requestString)
      def resourceType: Output[Option[String]] = output.map(_.resourceType)
      def responseString: Output[Option[String]] = output.map(_.responseString)
      def sslClientCertificate: Output[Option[String]] = output.map(_.sslClientCertificate)
      def sslClientPrivateKey: Output[Option[String]] = output.map(_.sslClientPrivateKey)
      def testInterval: Output[Int] = output.map(_.testInterval)
      def testObject: Output[Option[String]] = output.map(_.testObject)
      def testObjectPassword: Output[Option[String]] = output.map(_.testObjectPassword)
      def testObjectPort: Output[Option[Int]] = output.map(_.testObjectPort)
      def testObjectProtocol: Output[String] = output.map(_.testObjectProtocol)
      def testObjectUsername: Output[Option[String]] = output.map(_.testObjectUsername)
      def testTimeout: Output[Double] = output.map(_.testTimeout)
      def timeoutPenalty: Output[Option[Double]] = output.map(_.timeoutPenalty)

  given optionOutputOps: {} with
    extension(output: Output[Option[GtmPropertyLivenessTest]])
      def answersRequired: Output[Option[Boolean]] = output.map(_.flatMap(_.answersRequired))
      def disableNonstandardPortWarning: Output[Option[Boolean]] = output.map(_.flatMap(_.disableNonstandardPortWarning))
      def disabled: Output[Option[Boolean]] = output.map(_.flatMap(_.disabled))
      def errorPenalty: Output[Option[Double]] = output.map(_.flatMap(_.errorPenalty))
      def httpError3xx: Output[Option[Boolean]] = output.map(_.flatMap(_.httpError3xx))
      def httpError4xx: Output[Option[Boolean]] = output.map(_.flatMap(_.httpError4xx))
      def httpError5xx: Output[Option[Boolean]] = output.map(_.flatMap(_.httpError5xx))
      def httpHeaders: Output[Option[scala.collection.immutable.List[besom.api.akamai.outputs.GtmPropertyLivenessTestHttpHeader]]] = output.map(_.flatMap(_.httpHeaders))
      def name: Output[Option[String]] = output.map(_.map(_.name))
      def peerCertificateVerification: Output[Option[Boolean]] = output.map(_.flatMap(_.peerCertificateVerification))
      def recursionRequested: Output[Option[Boolean]] = output.map(_.flatMap(_.recursionRequested))
      def requestString: Output[Option[String]] = output.map(_.flatMap(_.requestString))
      def resourceType: Output[Option[String]] = output.map(_.flatMap(_.resourceType))
      def responseString: Output[Option[String]] = output.map(_.flatMap(_.responseString))
      def sslClientCertificate: Output[Option[String]] = output.map(_.flatMap(_.sslClientCertificate))
      def sslClientPrivateKey: Output[Option[String]] = output.map(_.flatMap(_.sslClientPrivateKey))
      def testInterval: Output[Option[Int]] = output.map(_.map(_.testInterval))
      def testObject: Output[Option[String]] = output.map(_.flatMap(_.testObject))
      def testObjectPassword: Output[Option[String]] = output.map(_.flatMap(_.testObjectPassword))
      def testObjectPort: Output[Option[Int]] = output.map(_.flatMap(_.testObjectPort))
      def testObjectProtocol: Output[Option[String]] = output.map(_.map(_.testObjectProtocol))
      def testObjectUsername: Output[Option[String]] = output.map(_.flatMap(_.testObjectUsername))
      def testTimeout: Output[Option[Double]] = output.map(_.map(_.testTimeout))
      def timeoutPenalty: Output[Option[Double]] = output.map(_.flatMap(_.timeoutPenalty))


